// script.js

// Mapbox access token
mapboxgl.accessToken = 'pk.eyJ1IjoidmlyYWoxOCIsImEiOiJjbHl6aW14eXAyOWthMnJzNjdoemNyNzNzIn0.9WNEhTx1m9LR5RmhxxVL4A';

document.addEventListener('DOMContentLoaded', () => {
  const map = new mapboxgl.Map({
    container: 'map',
    style: 'mapbox://styles/mapbox/streets-v11',
    center: [72.8333, 18.9298], // Coordinates for BSE building, Mumbai
    zoom: 17, // Adjust zoom level as needed
    pitch: 65, // Tilt the map for 3D effect
    bearing: -17.6, // Adjust bearing for better view
  });

  map.on('load', () => {
    // Add 3D buildings layer
    map.addLayer({
      'id': '3d-buildings',
      'source': 'composite',
      'source-layer': 'building',
      'filter': ['==', 'extrude', 'true'],
      'type': 'fill-extrusion',
      'minzoom': 15,
      'paint': {
        'fill-extrusion-color': '#A2B9E3',
        'fill-extrusion-height': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'height']
        ],
        'fill-extrusion-base': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'min_height']
        ],
        'fill-extrusion-opacity': 0.6
      }
    });

    // Add custom marker with logo image for BSE Building
    const bseMarkerElement = document.createElement('div');
    bseMarkerElement.className = 'custom-marker';
    bseMarkerElement.style.backgroundImage = 'url(/assets/bse_image.png)'; // Path to your image
    new mapboxgl.Marker(bseMarkerElement)
      .setLngLat([72.8333, 18.9298])
      .addTo(map);

    // Add Popup with description for BSE Building
    const bsePopup = new mapboxgl.Popup({ closeOnClick: false })
      .setLngLat([72.8333, 18.9298])
      .setHTML(`<h3>BSE Building</h3><p>This is the Bombay Stock Exchange building. <a href="https://en.wikipedia.org/wiki/Bombay_Stock_Exchange" target="_blank">Learn more</a></p>`)
      .addTo(map);
    
    bsePopup.getElement().addEventListener('click', () => {
      document.getElementById('info').innerHTML = 'The Bombay Stock Exchange (BSE) is an Indian stock exchange located at Dalal Street, Mumbai. Established in 1875, the BSE is Asia\'s oldest stock exchange.';
    });

    // Add custom marker with logo image for Gateway of India
    const gatewayMarkerElement = document.createElement('div');
    gatewayMarkerElement.className = 'custom-marker';
    gatewayMarkerElement.style.backgroundImage = 'url(/images/gatewayImage.png)'; // Path to your image
    new mapboxgl.Marker(gatewayMarkerElement)
      .setLngLat([72.8347, 18.9217]) // Coordinates for Gateway of India
      .addTo(map);

    // Add Popup with description for Gateway of India
    const gatewayPopup = new mapboxgl.Popup({ closeOnClick: false })
      .setLngLat([72.82661016935064, 19.00282257199499]) // Coordinates for Gateway of India
      .setHTML('<h3>World One Center</h3><p>This is the ONE WORLD CENTER. <a href="https://en.wikipedia.org/wiki/World_One" target="_blank">Learn more</a></p>')
      .addTo(map);
    
    gatewayPopup.getElement().addEventListener('click', () => {
      document.getElementById('info').innerHTML = 'World One is a supertall residential skyscraper in Mumbai, India. It is located on a 17-acre site in Upper Worli, South Mumbai.';
    });
  });

  // Clean up on page unload
  window.addEventListener('beforeunload', () => {
    map.remove();
  });
});
