// script.js

// Mapbox access token
mapboxgl.accessToken = 'pk.eyJ1IjoidmlyYWoxOCIsImEiOiJjbHl6aW14eXAyOWthMnJzNjdoemNyNzNzIn0.9WNEhTx1m9LR5RmhxxVL4A'; // Replace with your actual access token

const companyData = [
  { id: 1, url: "/assets/bom.png", name: "Google", info: "absvs",address:"Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051",email:"google@gmail.com",phone:"8485874272" },
  { id: 2, url: "/assets/bse_image.png", name: "Facebook", info: "a1234",address:"Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051",email:"eg2123@gmail",phone:"16582353" },
  { id: 3, url: "/assets/bom.png", name: "Infomanav Technologies", info: "absvs",address:"Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051",email:"viraj@123",phone:"8585203202" },
  { id: 4, url: "/assets/bse_image.png", name: "Autotropic Cloud Tech.", info: "absvs",address:"Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051",email:"eg2123@gmail",phone:"0235-61548998" }
];

document.addEventListener('DOMContentLoaded', () => {
  const map = new mapboxgl.Map({
    container: 'map',
    style: 'mapbox://styles/mapbox/streets-v11',
    center: [72.8333, 18.9298],
    zoom: 17,
    pitch: 65,
    bearing: -17.6,
  });

  // Add navigation, fullscreen control, and geocoder
  const nav = new mapboxgl.NavigationControl();
  map.addControl(nav, 'top-right');
  map.addControl(new mapboxgl.FullscreenControl(), 'top-right');
  const geocoder = new MapboxGeocoder({
    accessToken: mapboxgl.accessToken,
    mapboxgl: mapboxgl
  });
  map.addControl(geocoder, 'top-left');

  function toggleDivB(index) {
    console.log('Toggling div', index);
    const divB = document.querySelector(`#div-b-${index}`);
    if (divB) {
      divB.classList.toggle('show');
    }
  }

  map.on('load', () => {
    // Add 3D buildings layer
    map.addLayer({
      'id': '3d-buildings',
      'source': 'composite',
      'source-layer': 'building',
      'filter': ['==', 'extrude', 'true'],
      'type': 'fill-extrusion',
      'minzoom': 15,
      'paint': {
        'fill-extrusion-color': '#A2B9E3',
        'fill-extrusion-height': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'height']
        ],
        'fill-extrusion-base': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'min_height']
        ],
        'fill-extrusion-opacity': 0.6
      }
    });

    // Add markers and popups
    const bseMarkerElement = document.createElement('div');
    bseMarkerElement.className = 'custom-marker';
    bseMarkerElement.style.backgroundImage = 'url(/assets/bse_image.png)';
    new mapboxgl.Marker(bseMarkerElement)
      .setLngLat([72.8333, 18.9298])
      .addTo(map);

    const bsePopup = new mapboxgl.Popup({ closeOnClick: false })
      .setLngLat([72.8333, 18.9298])
      .setHTML(`<h3>BSE Building</h3><p>This is the Bombay Stock Exchange building. <a href="https://en.wikipedia.org/wiki/Bombay_Stock_Exchange" target="_blank">Learn more</a></p>`)
      .addTo(map);

    bsePopup.getElement().addEventListener('click', () => {
      document.getElementById('info').innerHTML = 'The Bombay Stock Exchange (BSE) is an Indian stock exchange located at Dalal Street, Mumbai. Established in 1875, the BSE is Asia\'s oldest stock exchange.';
    });

    const gatewayMarkerElement = document.createElement('div');
    gatewayMarkerElement.className = 'custom-marker';
    gatewayMarkerElement.style.backgroundImage = 'url(/images/gatewayImage.png)';
    new mapboxgl.Marker(gatewayMarkerElement)
      .setLngLat([72.8347, 18.9217])
      .addTo(map);

    const gatewayPopup = new mapboxgl.Popup({ closeOnClick: false })
      .setLngLat([72.82661016935064, 19.00282257199499])
      .setHTML('<h3>World One Center</h3><p>This is the ONE WORLD CENTER. <a href="https://en.wikipedia.org/wiki/World_One" target="_blank">Learn more</a></p>')
      .addTo(map);

    gatewayPopup.getElement().addEventListener('click', () => {
      document.getElementById('info').innerHTML = 'World One is a supertall residential skyscraper in Mumbai, India. It is located on a 17-acre site in Upper Worli, South Mumbai.';
    });

    const bomMarkerElement = document.createElement('div');
    bomMarkerElement.className = 'custom-marker';
    bomMarkerElement.style.backgroundImage = 'url(/assets/bom.png)';
    new mapboxgl.Marker(bomMarkerElement)
      .setLngLat([72.83434923653304, 18.930322381579053])
      .addTo(map);

    bomMarkerElement.addEventListener('click', () => {
      let companyInfo = '';
      companyData.forEach((i, index) => {
        companyInfo += `
          <div class="info-item" data-index="${index}" style="display:flex; flex-direction:column;">
          <div style="display:flex;position:relative; margin-left:10px;right:50px; ">
            <img src="${i.url}" alt="" style="margin-left:0px; width: 50px; height: 50px; border-radius: 50%;">
            <p style="width: 80px; position:relative; margin-left: 80px;">${i.name}</p>
            </div>
            <div style="display:flex; flex-direction:column;">
            
            <p style="width: 100%; margin-left: 10px;">Address:- ${i.address}</p>
            <p style="width: 100%; margin-left: 10px;">Contact :- ${i.phone}</p>
            <p style="width: 100%; margin-left: 10px;">Email :- ${i.email}</p>
            </div>
          </div>
          <div id="div-b-${index}" class="div-b">
            ${i.info}
          </div>
        `;
      });

      const infoInner = document.getElementById('info-inner');
      if (infoInner) {
        infoInner.innerHTML = companyInfo;

        // Add click event listeners for dynamically created divs
        infoInner.querySelectorAll('.info-item').forEach((element) => {
          element.addEventListener('click', () => {
            const index = element.getAttribute('data-index');
            toggleDivB(index);
          });
        });
      }
    });

    const customMarkerElement = document.createElement('div');
    customMarkerElement.className = 'custom-marker';
    customMarkerElement.style.width = '30px';
    customMarkerElement.style.height = '30px';
    customMarkerElement.style.borderRadius = '50%';
    customMarkerElement.style.display = 'flex';
    customMarkerElement.style.alignItems = 'center';
    customMarkerElement.style.justifyContent = 'center';
    customMarkerElement.style.color = '#FFFFFF';
    customMarkerElement.style.fontSize = '20px';
    customMarkerElement.innerText = '📍';

    new mapboxgl.Marker(customMarkerElement)
      .setLngLat([72.83267386130679, 18.929222131310798])
      .addTo(map);
  });

  window.addEventListener('beforeunload', () => {
    map.remove();
  });
});
