let map;
// Mapbox access token
mapboxgl.accessToken = 'pk.eyJ1IjoidmlyYWoxOCIsImEiOiJjbHl6aW14eXAyOWthMnJzNjdoemNyNzNzIn0.9WNEhTx1m9LR5RmhxxVL4A'; // Replace with your actual access token

const companyData = [
  { id: 1, url: "/assets/bom.png", name: "Google", info: "absvs", address: "Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051", email: "google@gmail.com", phone: "8485874272" },
  { id: 2, url: "/assets/bse_image.png", name: "Facebook", info: "a1234", address: "Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051", email: "eg2123@gmail", phone: "16582353" },
  { id: 3, url: "/assets/bom.png", name: "Infomanav Technologies", info: "absvs", address: "Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051", email: "viraj@123", phone: "8585203202" },
  { id: 4, url: "/assets/bse_image.png", name: "Autotropic Cloud Tech.", info: "absvs", address: "Level 7, Plot, C, FIFC Building, 54&55, G Block BKC, Bandra East, Mumbai, Maharashtra 400051", email: "eg2123@gmail", phone: "0235-61548998" }
];

document.addEventListener('DOMContentLoaded', () => {
  map = new mapboxgl.Map({
    container: 'map',
    style: 'mapbox://styles/mapbox/streets-v11',
    center: [72.8333, 18.9298],
    zoom: 17,
    pitch: 65,
    bearing: -17.6,
  });

  // Add navigation, fullscreen control, and geocoder
  const nav = new mapboxgl.NavigationControl();
  map.addControl(nav, 'top-right');
  map.addControl(new mapboxgl.FullscreenControl(), 'top-right');
  const geocoder = new MapboxGeocoder({
    accessToken: mapboxgl.accessToken,
    mapboxgl: mapboxgl
  });
  map.addControl(geocoder, 'top-left');

  function toggleDivB(index) {
    console.log('Toggling div', index);
    const divB = document.querySelector(`#div-b-${index}`);
    if (divB) {
      divB.classList.toggle('show');
    }
  }

  map.on('load', () => {
    // Add 3D buildings layer
    map.addLayer({
      'id': '3d-buildings',
      'source': 'composite',
      'source-layer': 'building',
      'filter': ['==', 'extrude', 'true'],
      'type': 'fill-extrusion',
      'minzoom': 15,
      'paint': {
        'fill-extrusion-color': '#A2B9E3',
        'fill-extrusion-height': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'height']
        ],
        'fill-extrusion-base': [
          'interpolate',
          ['linear'],
          ['zoom'],
          15,
          0,
          15.05,
          ['get', 'min_height']
        ],
        'fill-extrusion-opacity': 0.6
      }
    });

    // Add markers and popups

    map.addSource('circle', {
      'type': 'geojson',
      'data': {
          'type': 'FeatureCollection',
          'features': []
      }
  });

  map.addLayer({
    'id': 'circle-layer',
    'type': 'fill',
    'source': 'circle',
    'layout': {},
    'paint': {
        'fill-color': '#088',
        'fill-opacity': 0.3
    }
});



  });

  window.addEventListener('beforeunload', () => {
    map.remove();
  });
});

//Dropdown List Code
document.querySelectorAll(".option-placeholder").forEach(op => {
  op.setAttribute("selected", "");
  op.setAttribute("disabled", "");
  op.setAttribute("hidden", "");
});

document.querySelectorAll(".form-select-container").forEach(sc => {
  let select_html = sc.querySelector("select");

  let select = document.createElement("div");
  select.classList.add("form-select");

  let option_wrapper = document.createElement("div");
  option_wrapper.classList.add("form-option-wrapper");

  let option_placeholder = document.createElement("div");
  option_placeholder.classList.add("form-option-placeholder");
  option_placeholder.textContent = sc.querySelector(".option-placeholder").textContent;
  option_placeholder.setAttribute("data-default", sc.querySelector(".option-placeholder").textContent);

  let option_placeholder_container = document.createElement("div");
  option_placeholder_container.classList.add("form-option-placeholder-container");
  option_placeholder_container.appendChild(option_placeholder);
  option_wrapper.appendChild(option_placeholder_container);

  let option_container = document.createElement("div");
  option_container.classList.add("form-option-container");

  // Assigning values to options
  const cities = [
    { name: 'Mumbai', lat: '19.073902162172878', lng: '72.87188638115168' },
    { name: 'Pune', lat: '18.51874315744519', lng: '73.85661570483757' },
    { name: 'Nashik', lat: '20.014634187522734', lng: '73.7133512360573' }
  ]


  cities.forEach(city => {
    let option = document.createElement("div");
    option.classList.add("form-option");
    option.textContent = city.name;
    option.setAttribute("data-city", city.name);
    option.setAttribute("data-lat", city.lat); // Set the latitude
    option.setAttribute("data-lng", city.lng); // Set the longitude
    option_container.appendChild(option);
  });

  option_wrapper.appendChild(option_container);

  let select_option_placeholder = option_placeholder.cloneNode(true);

  select.appendChild(select_option_placeholder);
  select.appendChild(option_wrapper);
  sc.appendChild(select);
});

document.querySelectorAll(".form-select-container > .form-select > .form-option-placeholder").forEach(f_o_p => {
  f_o_p.addEventListener("click", openOptionList);
  f_o_p.addEventListener("blur", closeOptionList, true);
  f_o_p.closest(".form-select").querySelector(".form-option-wrapper").querySelectorAll(".form-option-placeholder-container > .form-option-placeholder, .form-option-container > .form-option").forEach(f_o => f_o.addEventListener("click", closeOptionList));
});

function openOptionList(e) {
  let form_select_container = e.currentTarget.closest(".form-select-container");
  form_select_container.classList.add("active");

  let form_option_container = e.currentTarget.closest(".form-select").querySelector(".form-option-wrapper > .form-option-container");
  form_option_container.style.height = "calc(" + form_option_container.scrollHeight + "px + 1rem)";
  //form_option_container.style.height = "calc(100px + 1rem)";
}

function closeOptionList(e) {
  let form_select_container = e.currentTarget.closest(".form-select-container");
  form_select_container.classList.remove("active");

  let form_option_container = e.currentTarget.closest(".form-select").querySelector(".form-option-wrapper > .form-option-container");
  form_option_container.style.height = 0;
}



document.querySelectorAll(".form-select-container > .form-select > .form-option-wrapper").forEach(f_o_w => {
  let form_options = f_o_w.querySelectorAll(".form-option-placeholder-container > .form-option-placeholder, .form-option-container > .form-option");

  form_options.forEach(option => {
    option.addEventListener("click", (e) => updateOption(e, form_options));
  });
});
//Main function
const PassCity = async (city) => {
  console.log(`Searching for city: ${city}`);
  try {
    const response = await fetch('./cityData.json');  // Adjust path if necessary
    const data = await response.json();

    if (data[city.toLowerCase()]) {
      console.log(`Data found for ${city}:`, data[city.toLowerCase()]);

      console.log("Building Latitude :- ",)
      const lat = data[city.toLowerCase()].lat
      const lon = data[city.toLowerCase()].long
      map.setCenter([parseFloat(lat), parseFloat(lon)]);

      data[city.toLowerCase()].building.forEach((building) => {
        console.log(building);

        console.log('lat :-', building.longitude, 'lon :-', building.latitude);

        const markerElement = document.createElement('div');
        markerElement.className = 'custom-marker';
        markerElement.id = building.id;
        markerElement.style.backgroundImage = `url(${building.imageUrl})`;

        const marker = new mapboxgl.Marker(markerElement)
          .setLngLat([building.longitude, building.latitude])
          .addTo(map);

        //function for distance ->

          markerElement.addEventListener('click', () => {
            const buildingName = markerElement.id; // Replace with the desired building name
            displayBuildingData(buildingName);
            updateCircle([building.longitude, building.latitude], handleDistanceChange());
          });
          

      })

    } else {
      console.error(`City "${city}" not found in the data`);
      return null;
    }
  } catch (error) {
    console.error('Error fetching city data:', error);
    return null;
  }
};

// fetch('/data/markers.json')
// .then(res=>res.json())
// .then(data=>{
//   data.forEach(marker=>{
//     const markerElement = document.createElement('div');
//     markerElement.className = 'custom-marker';
//     markerElement.style.backgroundImage = `url(${marker.imageUrl})`;

//     new mapboxgl.Marker(markerElement)
//     .setLngLat([marker.longitude,marker.latitude])
//     .addTo(map);
//   })
// })

async function displayBuildingData(buildingName) {
  try {
    // Fetch the company data from the JSON file
    const response = await fetch('./companyData.json');
    const data = await response.json();

    // Find the building with the specified name
    const building = data.find(b => b.bulding === buildingName);

    // Check if the building exists
    if (!building) {
      console.error(`Building with name ${buildingName} not found.`);
      return;
    }

    // Initialize a variable to hold the HTML content for companies
    let companyInfo = '';

    // Iterate through each company in the found building
    building.companies.forEach((company, index) => {
      companyInfo += `
        <div class="info-item" data-index="${index}" style="display:flex; flex-direction:column;">
          <div style="display:flex;position:relative; margin-left:10px;right:50px;">
            <img src="${company.url}" alt="" style="margin-left:0px; width: 50px; height: 50px; border-radius: 50%;">
            <p style="width: 80px; position:relative; margin-left: 80px;">${company.name}</p>
          </div>
          <div style="display:flex; flex-direction:column;">
            <p style="width: 100%; margin-left: 10px;">Address:- ${company.address}</p>
            <p style="width: 100%; margin-left: 10px;">Contact :- ${company.phone}</p>
            <p style="width: 100%; margin-left: 10px;">Email :- ${company.email}</p>
          </div>
        </div>
        <div id="div-b-${index}" class="div-b">
          ${company.info}
        </div>
      `;
    });

    // Update the HTML content of the info-inner element
    const infoInner = document.getElementById('info-inner');
    if (infoInner) {
      infoInner.innerHTML = companyInfo;

      // Add click event listeners for dynamically created divs
      infoInner.querySelectorAll('.info-item').forEach((element) => {
        element.addEventListener('click', () => {
          const index = element.getAttribute('data-index');
          toggleDivB(index);
        });
      });
    }
  } catch (error) {
    console.error('Error fetching company data:', error);
  }
}


function updateCircle(center, radiusKm) {
  // Convert the radius from kilometers to meters
  const radiusMeters = radiusKm * 1000;

  // Define the GeoJSON data for the circle
  const circleData = {
      'type': 'FeatureCollection',
      'features': [
          {
              'type': 'Feature',
              'geometry': {
                  'type': 'Polygon',
                  'coordinates': [getCircleCoordinates(center, radiusMeters)]
              }
          }
      ]
  };

  // Update the data for the circle source
  map.getSource('circle').setData(circleData);
}

// Function to calculate the circle coordinates
function getCircleCoordinates(center, radius) {
  const points = 64;
  const coords = [];
  const [lon, lat] = center;

  for (let i = 0; i < points; i++) {
      const angle = (i * 360) / points;
      const radians = angle * (Math.PI / 180);

      const offsetLat = (radius / 6378137) * (180 / Math.PI) * Math.sin(radians);
      const offsetLng = (radius / 6378137) * (180 / Math.PI) * Math.cos(radians) / Math.cos(lat * Math.PI / 180);

      coords.push([lon + offsetLng, lat + offsetLat]);
  }
  coords.push(coords[0]); // Close the polygon

  return coords;
}

function updateMapCenter(lat, lng) {
  map.setCenter([parseFloat(lng), parseFloat(lat)]);
}
function updateOption(e, options) {
  let form_option_placeholder = e.currentTarget.closest(".form-select").querySelector(".form-option-placeholder");
  form_option_placeholder.textContent = e.currentTarget.textContent;

  let select_html = e.currentTarget.closest(".form-select-container").querySelector("select");

  if (e.currentTarget.classList.contains("form-option-placeholder")) {
    select_html.selectedIndex = 0;
    options.forEach(o => o.classList.remove("active"));
  } else if (e.currentTarget.classList.contains("form-option")) {
    select_html.selectedIndex = Array.prototype.indexOf.call(options, e.target);

    options.forEach(o => o.classList.remove("active"));
    e.currentTarget.classList.add("active");

    // Get the latitude and longitude from the selected option
    const lat = e.currentTarget.getAttribute("data-lat");
    const lng = e.currentTarget.getAttribute("data-lng");
    const city = e.currentTarget.getAttribute("data-city");

    // Pass the latitude and longitude to PassCity



    PassCity(city);
  }
}






// Example usage: update the map center to a new location
// You can call this function whenever you need to update the map's center




document.addEventListener("click", function (e) {
  document.querySelectorAll(".form-select-container").forEach(f_s_c => {
    if (f_s_c.classList.contains("active") && !f_s_c.contains(e.target)) {
      f_s_c.classList.remove("active");
      f_s_c.querySelector(".form-option-container").style.height = 0;
    }
  });
});

/*Dropdown Menu*/
$('.dropdown').click(function () {
  $(this).attr('tabindex', 1).focus();
  $(this).toggleClass('active');
  $(this).find('.dropdown-menu').slideToggle(300);
});
$('.dropdown').focusout(function () {
  $(this).removeClass('active');
  $(this).find('.dropdown-menu').slideUp(300);
});
$('.dropdown .dropdown-menu li').click(function () {
  $(this).parents('.dropdown').find('span').text($(this).text());
  $(this).parents('.dropdown').find('input').attr('value', $(this).attr('id'));
});


$('.dropdown-menu li').click(function () {
  var input = '<strong>' + $(this).parents('.dropdown').find('input').val() + '</strong>',
  msg = '<span class="msg">Hidden input value: ';
  $('.msg').html(msg + input + '</span>');
  }); 
  
  
  function handleDistanceChange() {
    const dropdown = document.getElementById('distanceDropdown');
    const selectedValue = dropdown.value;
  
    if (selectedValue) {
      console.log(`Selected distance: ${selectedValue}`);
    }
    return selectedValue
  }
  
 